#include<qapp.h>
#include<qwidget.h>
#include<qwmatrix.h>
#include<qdatetm.h>
#include<qimage.h>
#include<qbitmap.h>
#include<qbrush.h>
#include<qpainter.h>

#include<stdio.h>
#include<stdlib.h>
//#include<math.h>

// pixmaps:  object, raster
#include "p_object.xpm"
#include "p_raster.xpm"

int num=1; bool useMask=TRUE; char *cmd=NULL;
char *pixmapName=NULL, *rasterName=NULL;
int delay=5; bool bNoFlicker=TRUE;

inline int max(int x,int y) {if (x>y) return x; else return y; }

class Data 
{
public:
	Data();
public:
	struct Desk:public QWidget{Desk();} _desktop; QRect _deskRect;
	QPixmap _object,_raster,_rotObj[4],_r2x2; 
};
Data::Desk::Desk():QWidget(0,0,WType_Desktop|WPaintDesktop|WPaintUnclipped){}

Data::Data()
{
	QBitmap bm;
	// read Pixmaps.
	if (pixmapName) {
		_object.load(pixmapName,"XPM");
	} else {
		_object=QPixmap((const char **)object);
	}
	if (!useMask) { 
		bm.resize(_object.size()); bm.fill(color1);
		_object.setMask(bm);
	}
	if (rasterName) {
		_raster.load(rasterName,"XPM");
	} else {
		_raster=QPixmap((const char **)raster);
	}
	if (!useMask) { 
		bm.resize(_raster.size()); bm.fill(color1);
		_raster.setMask(bm);
	}
	if (_raster.isNull()) {
		fprintf(stderr,"%s: invalid raster pixmap.\n",cmd);
		exit(2);
	}
	if (_object.isNull()) {
		fprintf(stderr,"%s: invalid object pixmap.\n",cmd);
		exit(2);
	}
	if (_object.width() != _object.height()) {
		fprintf(stderr,"%s: object pixmap not square.\n",cmd);
		exit(2);
	}
	
	QWMatrix m; m.rotate(-90);
	for (int i=0; i<4; i++) {
		_rotObj[i]=_object.xForm(m); m.rotate(90);
	}
	QRect rr=_raster.rect(), cr=_object.rect(); QSize mr;

	//_r2x2=QPixmap(rr.width()*2,rr.height()*2);
	mr.setWidth(max(rr.width(),cr.width())+cr.width());
	mr.setHeight(max(rr.height(),cr.height())+cr.height());

	_r2x2=QPixmap(mr); 
	{ // stackframe
		QBrush br(black,_raster); 
		QPainter gc(&_r2x2);
		gc.fillRect(_r2x2.rect(),br);
	}

	_deskRect=_desktop.rect(); 
	_deskRect.setRight( _desktop.width() -_object.width() );
	_deskRect.setBottom( _desktop.height() -_object.height() );
}

class Object : public QObject
{
public:
	Object(Data *d,QObject *parent=0, const char *name=0 );
	~Object();
protected:
	Data *_d;  QPoint _pos,_oldpos; 
	int _dir, _olddir, _speed, _step, _timerId;
protected:
	void timerEvent(QTimerEvent *e);
	void drawObject();
	void turnObject();
	void moveObject();
	void clearObject(bool bOld=TRUE);
	void clearPxmObject(QPixmap *pPM);
	bool checkRaster();
	void changeSpeed(bool fast);
};

Object::Object(Data *d,QObject *parent, const char *name )
	: QObject( parent, name ) , _d(d)
{
	QRect &dR = _d->_deskRect; _timerId=0; _step = 1 ;

	// initial position, speed, ... 
	_dir = rand() % 4;  changeSpeed(TRUE);
	if (_dir & 1) { // up/down
		_pos.setX( dR.left() + rand()% dR.width() );
		_pos.setY( (_dir >= 2) ? dR.top() : dR.bottom() ); 
	} else { // left/right
		_pos.setY( dR.top() + rand()% dR.height() );
		_pos.setX( (_dir >= 2) ? dR.left() : dR.right() ); 
	}
}

Object::~Object() { clearObject(FALSE); }

void Object::clearObject(bool bOld) 
{
	QPoint p=(bOld)?_oldpos:_pos; 
	int dir=(bOld)?_olddir:_dir;
	QSize rs=_d->_raster.size(), cs=_d->_object.size();
	QPoint rpos( p.x() % rs.width() , p.y() % rs.height() );
	QPixmap tmp(cs);
	bitBlt( &tmp, QPoint(0,0) , 
	        &_d->_r2x2, QRect(rpos,cs), CopyROP );
	tmp.setMask(*_d->_rotObj[dir].mask() );
	bitBlt( &_d->_desktop, p , 
			&tmp , tmp.rect() , CopyROP );
}
void Object::clearPxmObject(QPixmap *pPM) 
{
	QSize rs=_d->_raster.size(), cs=_d->_object.size();
	QPoint rpos( _oldpos.x() % rs.width() , _oldpos.y() % rs.height() );
	QPoint dpos( _oldpos.x() - _pos.x() , _oldpos.y() - _pos.y() );
	QPixmap tmp(cs);
	bitBlt( &tmp, QPoint(0,0) , 
	        &_d->_r2x2, QRect(rpos,cs), CopyROP );
	tmp.setMask(*_d->_rotObj[_dir].mask() );
	bitBlt( pPM, dpos, &tmp , tmp.rect() , CopyROP );
}
void Object::drawObject()
{
	bitBlt( &_d->_desktop, _pos, 
	        &_d->_rotObj[_dir], _d->_rotObj[_dir].rect(), CopyROP );
}
void Object::timerEvent(QTimerEvent *)
{
	_oldpos=_pos; _olddir=_dir;
	if (bNoFlicker) {
		moveObject();
		clearObject();
	} else {
		clearObject();
		moveObject();
	}
	drawObject();
}

bool Object::checkRaster()
{
static QPoint p0(0,0);
	QSize rs=_d->_raster.size(), cs=_d->_object.size();
	QPoint rpos( _pos.x() % rs.width() , _pos.y() % rs.height() );

	QPixmap ps(cs); QPixmap tpm(cs); QBitmap tbm(cs);
	bitBlt( &ps, p0, &_d->_desktop, QRect(_pos,cs), CopyROP );
	if (bNoFlicker) { clearPxmObject(&ps); }
	bitBlt( &ps, p0, &_d->_r2x2, QRect(rpos,cs), XorROP );
	tpm.fill(black); tbm.fill(color1);
	bitBlt( &tbm, p0, _d->_rotObj[_dir].mask() , tbm.rect(), XorROP);
	tpm.setMask(tbm);
	if (useMask) {
		bitBlt( &ps, p0, &tpm, tpm.rect(), CopyROP); 
	}

	QImage qr=ps.convertToImage().convertDepth(32);
	uchar *uptr=(uchar*)qr.bits(), *end=uptr + (qr.numBytes() >> 0); 
	while (uptr<end) { if (*uptr) { return FALSE; } uptr++; }
	return TRUE;
}

void Object::turnObject() { _dir += 3 + rand() % 3 ; _dir %= 4; }

void Object::changeSpeed(bool fast) {
	int bd= (fast) ? delay : 5*delay ;
	_speed = bd + rand() % bd; 
	if (fast) { _step++; if (_step>7) _step=7; } else { _step=1; }
	if (_timerId) { killTimer(_timerId); }
	_timerId=startTimer(_speed);
}

void Object::moveObject()
{
	QPoint oldpos=_pos;
	switch (_dir) {
		case 0: _pos.rx() -= _step; break; // left
		case 1: _pos.ry() -= _step; break; // up
		case 2: _pos.rx() += _step; break; // right
		case 3: _pos.ry() += _step; break; // down
	}
	if ( ! _d->_deskRect.contains(_pos)) { 
		_pos=oldpos; turnObject(); changeSpeed(FALSE); return; 
	}
	if ( ! checkRaster()) { // not same as raster ...
		if (_step>1) {
			clearObject(FALSE); _step/=2; return; 
		} else {
			clearObject(FALSE); _pos=oldpos; 
			changeSpeed(FALSE); turnObject(); return;
		}
	} else if ( (rand() % 100) < 2 ) {
		turnObject();
	}
	changeSpeed(TRUE);
}

void usage()
{
	fprintf(stderr, "\
usage: %s [-n #] [-d #] [-m] [-p <file>] [-r <file>]\n\
   -n #  number of objects (default=%d)\n\
   -d #  minimum delay between moves. (default=%d)\n\
   -p <file>   xpm-file for the object (must be square)\n\
   -r <file>   xpm-file for background (what object will leave behind)\n\
   -m    disable transparent mode\n\
   -f    disable flicker-free mode\n\
Numbers passed to -n or -d must be positive (>0).\n\
", cmd, num, delay);
}

int main(int argc,char **argv) {
	QApplication q(argc,argv); 
	cmd=q.argv()[0];
	
	const QTime &tm=QTime::currentTime();
	srand( tm.msec() + 1000* tm.second() +
		60000* tm.minute() + 3600000*tm.hour() );
	
	for (int i=1; i<qApp->argc(); i++) {
		char *cptr=qApp->argv()[i];
		if (*cptr!='-') { usage(); exit(1); }
		switch (cptr[1]) {
			case 'n': 
				if (cptr[2]!=0) {cptr+=2;} 
				else {cptr=qApp->argv()[i+1];i++;} 
				if (!cptr) { cptr=""; }
				num=atoi(cptr); if (num<1) {usage();exit(1);}
				break;
			case 'd': 
				if (cptr[2]!=0) {cptr+=2;} 
				else {cptr=qApp->argv()[i+1];i++;} 
				if (!cptr) { cptr=""; }
				delay=atoi(cptr); if (delay<1) {usage();exit(1);}
				break;
			case 'p':
				if (cptr[2]!=0) {cptr+=2;} 
				else {cptr=qApp->argv()[i+1];i++;} 
				if (!cptr) { cptr=""; }
				pixmapName=cptr;
				break;
			case 'r':
				if (cptr[2]!=0) {cptr+=2;} 
				else {cptr=qApp->argv()[i+1];i++;} 
				if (!cptr) { cptr=""; }
				rasterName=cptr;
				break;
			case 'm':
				useMask=FALSE;
				break;
			case 'f':
				bNoFlicker=FALSE;
				break;
			default: usage(); exit(1);
		} 
	}

	// argv must have been parsed before instanciating Data
	Data d; 

	{
		QObject lifetime;
		for (int i=0; i< num; i++) { new Object(&d,&lifetime); }

		qApp->exec();
	}
	
	return 0;
}

